/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.client.fx.particle.mote;

import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.orecruncher.dsurround.client.fx.particle.mote.MoteAgeable;
import org.orecruncher.dsurround.client.fx.particle.mote.RippleStyle;
import org.orecruncher.dsurround.registry.biome.BiomeUtil;
import org.orecruncher.lib.Color;

@SideOnly(value=Side.CLIENT)
public class MoteWaterRipple
extends MoteAgeable {
    private static final float TEX_SIZE_HALF = 0.5f;
    protected final float growthRate;
    protected float scale;
    protected float scaledWidth;
    protected float texU1;
    protected float texU2;
    protected float texV1;
    protected float texV2;

    public MoteWaterRipple(World world, double x, double y, double z) {
        super(world, x, y, z);
        RippleStyle style = RippleStyle.get();
        this.maxAge = style.getMaxAge();
        if (style.doScaling()) {
            this.scale = this.growthRate = (float)this.maxAge / 500.0f;
            this.scaledWidth = this.scale * 0.5f;
        } else {
            this.growthRate = 0.0f;
            this.scale = 0.0f;
            this.scaledWidth = 0.5f;
        }
        this.posY -= 0.2;
        Color waterColor = BiomeUtil.getColorForLiquid(world, (BlockPos)this.position);
        this.red = (int)(waterColor.red * 255.0f);
        this.green = (int)(waterColor.green * 255.0f);
        this.blue = (int)(waterColor.blue * 255.0f);
        this.texU1 = style.getU1(this.age);
        this.texU2 = style.getU2(this.age);
        this.texV1 = style.getV1(this.age);
        this.texV2 = style.getV2(this.age);
    }

    @Override
    public void update() {
        RippleStyle style = RippleStyle.get();
        if (style.doScaling()) {
            this.scale += this.growthRate;
            this.scaledWidth = this.scale * 0.5f;
        }
        if (style.doAlpha()) {
            this.alpha = (int)((float)(this.maxAge - this.age) / (float)(this.maxAge + 3) * 255.0f);
        }
        this.texU1 = style.getU1(this.age);
        this.texU2 = style.getU2(this.age);
        this.texV1 = style.getV1(this.age);
        this.texV2 = style.getV2(this.age);
    }

    @Override
    public void renderParticle(BufferBuilder buffer, Entity entityIn, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
        float x = this.renderX(partialTicks);
        float y = this.renderY(partialTicks);
        float z = this.renderZ(partialTicks);
        this.drawVertex(buffer, -this.scaledWidth + x, y, this.scaledWidth + z, this.texU2, this.texV2);
        this.drawVertex(buffer, this.scaledWidth + x, y, this.scaledWidth + z, this.texU2, this.texV1);
        this.drawVertex(buffer, this.scaledWidth + x, y, -this.scaledWidth + z, this.texU1, this.texV1);
        this.drawVertex(buffer, -this.scaledWidth + x, y, -this.scaledWidth + z, this.texU1, this.texV2);
    }
}

